package w83b.w83bOperacionesPaso.w83bPreavisos;

import java.io.InputStream;
import java.util.Date;
import java.util.List;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.commons.lang.StringUtils;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFFooter;
import org.apache.poi.hssf.usermodel.HSSFHeader;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.hssf.util.Region;
import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

import w83b.w83bBeans.W83bImpugnacionesBean;
import w83b.w83bBeans.W83bPreavisosBean;
import w83b.w83bBeans.W83bUsuarioXLNetsBean;
import w83b.w83bUtilidades.W83bUtilidadesExcel;
import w83b.w83bUtilidadesComunes.W83bClsConstantes;
import w83b.w83bUtilidadesComunes.W83bDateUtil;
import w83b.w83bUtilidadesComunes.W83bUtilidadesN38API;
import es.ejie.frmk.infraestructura.internacionalizacion.Q70GestorMensajesi18n;
import es.ejie.frmk.listeners.base.Q70ListenerUtils;
import es.ejie.frmk.presentacion.operacion.paso.Q70ActionPasoOP;
import es.ejie.frmk.presentacion.sesiondatos.Q70ContextoEJIE;

public class W83bFichaPreavisosAction extends Q70ActionPasoOP{


	
	protected void processOP(Q70ContextoEJIE contexto, ActionErrors errores, ActionMapping mapping,
			ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
		
		
	}

	protected ActionForward processForward(Q70ContextoEJIE contexto, ActionErrors errors, ActionMapping mapping, 
			ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {

		String strRutaExcel = Q70ListenerUtils.getApplicationProperty("RUTA_PLANTILLAS_EXCEL")+"plantillaExcelw83bFichaPreavisos.xls";
		InputStream inputStream = W83bFichaPreavisosAction.class.getResourceAsStream(strRutaExcel);
		HSSFWorkbook wb = new HSSFWorkbook(inputStream); // Creacin del libro
		wb.setSheetName(0,"Hoja1"); // Creacin de la hoja
        HSSFSheet sheet = wb.getSheetAt(0); // Creacin de la hoja
        
		W83bPreavisosBean preaviso=(W83bPreavisosBean)contexto.get("w83bPreavisosNuevoBeanTemp");
		HSSFHeader header = sheet.getHeader();//NOPMD
        
        W83bUsuarioXLNetsBean usuario = (W83bUsuarioXLNetsBean)contexto.get(W83bClsConstantes.CONSTANTE_CONTEXTO_USUARIO);
        String idioma = (String)contexto.get(W83bClsConstantes.CONSTANTE_CONTEXTO_IDIOMA);
        String provincia = W83bUtilidadesN38API.elegirProvinciaDelegacion(usuario.getPerfilXLNets());      
        W83bUtilidadesExcel.crearCabeceraPieEstandar(sheet, idioma,(W83bUsuarioXLNetsBean)contexto.get(W83bClsConstantes.CONSTANTE_CONTEXTO_USUARIO));
        header.setRight(W83bDateUtil.getInstance().getLocaleStringFromDate(new Date(), idioma));
        
        HSSFFooter footer = sheet.getFooter();//NOPMD

        footer.setCenter(((W83bUsuarioXLNetsBean)contexto.get(W83bClsConstantes.CONSTANTE_CONTEXTO_USUARIO)).getCalleListadosFormateada());
        footer.setRight(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.label.pag",idioma,new String[]{footer.page()}));//NOPMD
      
        HSSFRow row ; 
        HSSFCell cell;
        ////
        row = sheet.getRow((short)3); 
        cell = row.getCell((short)2);
        StringBuffer tituloImagenEs = new StringBuffer();
        StringBuffer tituloImagenEu = new StringBuffer();
        
        tituloImagenEs.append(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.informes.tituloImagenInforme_es",idioma));
        tituloImagenEu.append(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.informes.tituloImagenInforme_eu",idioma));
        cell.setCellValue(tituloImagenEu.toString());
        
        cell = row.getCell((short)4); 
        cell.setCellValue(tituloImagenEs.toString());
        tituloImagenEs = new StringBuffer();
        tituloImagenEu = new StringBuffer();
        if(W83bClsConstantes.CONSTANTE_SERVICIOS_CENTRALES.equals(provincia)){
        	tituloImagenEu.append(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.informes.direccionTrabajo_eu",idioma));
        	tituloImagenEs.append(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.informes.direccionTrabajo_es",idioma));
        }else if(W83bClsConstantes.CONSTANTE_ALAVA.equals(provincia)){
        	tituloImagenEu.append(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.informes.delegacionAlava_eu",idioma));
        	tituloImagenEs.append(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.informes.delegacionAlava_es",idioma));
        }else if(W83bClsConstantes.CONSTANTE_GIPUZKOA.equals(provincia)){
        	tituloImagenEu.append(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.informes.delegacionGuipuzcoa_eu",idioma));
        	tituloImagenEs.append(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.informes.delegacionGuipuzcoa_es",idioma));
        }else if(W83bClsConstantes.CONSTANTE_BIZKAIA.equals(provincia)){
        	tituloImagenEu.append(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.informes.delegacionBizkaia_eu",idioma));        	
        	tituloImagenEs.append(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.informes.delegacionBizkaia_es",idioma));        	
        }
        	        
        row = sheet.getRow((short)4); 
        cell = row.getCell((short)2);
        cell.setCellValue(tituloImagenEu.toString());
        
        cell = row.getCell((short)4); 
        cell.setCellValue(tituloImagenEs.toString());
        
        
        row = sheet.getRow((short)8); // Creacin de la fila 1
        cell = row.getCell((short)1);

        
        //Titulo
        row = sheet.getRow((short)8); 
        cell = row.getCell((short)1); 
        cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.preavisos.labels.ficha",idioma));

        //Datos del preaviso
        row = sheet.getRow((short)10); 
        cell = row.getCell((short)1); 

        cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.preavisos.labels.datosbasicos",idioma));
        
        //fin Datos del preaviso
        row = sheet.getRow((short)11); 
        cell = row.getCell((short)1); 
        cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.preavisos.labels.numpreaviso",idioma)
        		+":  "+preaviso.getCodTerritorio()+"/"+preaviso.getAnyoPreaviso()+"/"+preaviso.getNumPreaviso());
        
     
        row = sheet.getRow((short)12); 
        cell = row.getCell((short)1); 
        cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.preavisos.labels.fechentrada",idioma)
        		+":  "+preaviso.getFecha_entrada());
        
       
        cell = row.getCell((short)4); 
        cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.preavisos.labels.fechinicio",idioma)
        		+":  "+preaviso.getFecha_inicio());
          
        row = sheet.getRow((short)13); 
        cell = row.getCell((short)1); 
        String valor=null;
        if("S".equals(preaviso.getEleccion_parcial()))
        {
        	valor = Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.herramientas.si",idioma).toUpperCase();
        }
        else
        {
        	valor = Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.herramientas.no",idioma).toUpperCase();
        }
        String valor2 = W83bUtilidadesExcel.mayusculasCampoExcel(valor);
        valor = valor2;
        cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.preavisos.labels.eleccionparcial",idioma)+":  "+valor);//NOPMD

        cell = row.getCell((short)4); 
        if("S".equals(preaviso.getPreaviso_global()))
        {
        	valor = Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.herramientas.si",idioma);
        }
        else
        {
        	valor = Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.herramientas.no",idioma);
        }
        valor2 = W83bUtilidadesExcel.mayusculasCampoExcel(valor);
        valor = valor2;
        cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.preavisos.labels.prevglobal",idioma)+":  "+valor);//NOPMD
        
        row = sheet.getRow((short)14); 
        cell = row.getCell((short)1); 
        String numPreaviso = preaviso.getNum_registro();
        if(StringUtils.isEmpty(numPreaviso)){
        	numPreaviso = "";
        }
        cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.preavisos.labels.numregistroes",idioma)+":  "+numPreaviso.toUpperCase());//NOPMD
        
        row = sheet.getRow((short)14); 
        cell = row.getCell((short)4); 
        cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.preavisos.labels.fechregistroes",idioma)+":  "+preaviso.getFecha_registro());//NOPMD
        
        row = sheet.getRow((short)15); 
        cell = row.getCell((short)1); 
        cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.preavisos.labels.fecheleccion",idioma)+":  "+preaviso.getFecha_eleccion());//NOPMD
        
        row = sheet.getRow((short)15); 
        cell = row.getCell((short)4);
        String nActa = "";
        if(StringUtils.isNotEmpty(preaviso.getCodterrit_acta())
        		&&StringUtils.isNotEmpty(preaviso.getAnyo_acta())
        		&&StringUtils.isNotEmpty(preaviso.getNum_acta())){
        	nActa = preaviso.getCodterrit_acta()+"/"+preaviso.getAnyo_acta()+"/"+preaviso.getNum_acta();//NOPMD
        }
        cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.preavisos.labels.numacta",idioma)
        		+":  "+nActa);
        
        row = sheet.getRow((short)16); 
        cell = row.getCell((short)1); 
        if("A".equals(preaviso.getAdmon()))
        {
        	valor = Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.herramientas.si",idioma);
        }
        else
        {
        	valor = Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.herramientas.no",idioma);
        }
        valor2 = W83bUtilidadesExcel.mayusculasCampoExcel(valor);
        valor = valor2;
        cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.preavisos.labels.admon",idioma)
        		+":  "+valor);
        
        row = sheet.getRow((short)16); 
        cell = row.getCell((short)4); 
        if("E".equals(preaviso.getAdmon()))
        {
        	valor = Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.herramientas.si",idioma);
        }
        else
        {
        	valor = Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.herramientas.no",idioma);
        }
        valor2 = W83bUtilidadesExcel.mayusculasCampoExcel(valor);
        valor = valor2;
        cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.preavisos.labels.empresa",idioma)+":  "+valor);//NOPMD
        
        row = sheet.getRow((short)17); 
        cell = row.getCell((short)1); 
        valor = W83bUtilidadesExcel.mayusculasCampoExcel(preaviso.getConvenioTxt());//NOPMD
        String codConvenio = preaviso.getCodConvenio();
        if(StringUtils.isEmpty(codConvenio)){
        	codConvenio = "";
        }
        if(StringUtils.isEmpty(valor)){
        	valor = "";
        }
        cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.preavisos.labels.convenio",idioma)
        		+":  "+codConvenio+"-"+valor);
        int tamanyoTexto = cell.getStringCellValue().length();
        if(93<tamanyoTexto){
        	row.setHeightInPoints((short)(22*(tamanyoTexto/93)+1));
        }
        row = sheet.getRow((short)18); 
        cell = row.getCell((short)1);
        String observaciones = preaviso.getObservaciones();
        if(StringUtils.isEmpty(observaciones)){
        	observaciones = "";
        }
        valor = W83bUtilidadesExcel.mayusculasCampoExcel(observaciones);
        cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.preavisos.labels.observaciones",idioma)
        		+":  "+valor);
        tamanyoTexto = cell.getStringCellValue().length();
        if(93<tamanyoTexto){
        	row.setHeightInPoints((short)(22*(tamanyoTexto/93)+1));
        }                 
        HSSFRow rowTemp = sheet.getRow((short)10);
        row = sheet.createRow((short)20); 
        cell = row.createCell((short)1);
        cell.setCellStyle(rowTemp.getCell((short)1).getCellStyle());
        cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.preavisos.labels.promotoreselec",idioma));
        cell = row.createCell((short)2); 
        cell.setCellStyle(rowTemp.getCell((short)2).getCellStyle());
        cell = row.createCell((short)3); 
        cell.setCellStyle(rowTemp.getCell((short)3).getCellStyle());
        cell = row.createCell((short)4); 
        cell.setCellStyle(rowTemp.getCell((short)4).getCellStyle());
        cell = row.createCell((short)5); 
        cell.setCellStyle(rowTemp.getCell((short)5).getCellStyle());
        int numlinea=20;

        if (StringUtils.isNotEmpty(preaviso.getPromotores_desc()))
        {
        	 String [] descPromotores=preaviso.getPromotores_desc().split("\\?");
             String [] desc=null;
             rowTemp = sheet.getRow((short)18);
             for (int i=0;i<descPromotores.length;i++)
             {
             	desc=descPromotores[i].split("@");
             	row = sheet.createRow((short)++numlinea); 
             	sheet.addMergedRegion(new Region(numlinea,Short.parseShort("1"),numlinea,Short.parseShort("5")));//NOPMD
                 cell = row.createCell((short)1); 
                 valor = W83bUtilidadesExcel.mayusculasCampoExcel(desc[0]);
                 cell.setCellValue(desc[1] + "-" + valor);
                 cell.setCellStyle(rowTemp.getCell((short)1).getCellStyle());
                 cell = row.createCell((short)5); 
                 cell.setCellStyle(rowTemp.getCell((short)5).getCellStyle());
                 
             }
             
             rowTemp = sheet.getRow((short)18);
             cell = row.getCell((short)1); 
             cell.setCellStyle(rowTemp.getCell((short)1).getCellStyle());
             cell = row.createCell((short)2); 
             cell.setCellStyle(rowTemp.getCell((short)2).getCellStyle());
             cell = row.createCell((short)3); 
             cell.setCellStyle(rowTemp.getCell((short)3).getCellStyle());             
             cell = row.createCell((short)4); 
             cell.setCellStyle(rowTemp.getCell((short)4).getCellStyle());             
             ++numlinea;
             tamanyoTexto = cell.getStringCellValue().length();
             if(93<tamanyoTexto){
             	row.setHeightInPoints((short)(22*(tamanyoTexto/93)+1));
             }
        }
       
        row = sheet.createRow((short)++numlinea); 
        cell = row.createCell((short)1); 
        cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.preavisos.labels.datos_empresa",idioma));
        rowTemp = sheet.getRow((short)10);
        cell.setCellStyle(rowTemp.getCell((short)1).getCellStyle());
        cell = row.createCell((short)2); 
        cell.setCellStyle(rowTemp.getCell((short)2).getCellStyle());
        cell = row.createCell((short)3); 
        cell.setCellStyle(rowTemp.getCell((short)3).getCellStyle());
        cell = row.createCell((short)4); 
        cell.setCellStyle(rowTemp.getCell((short)4).getCellStyle());
        cell = row.createCell((short)5); 
        cell.setCellStyle(rowTemp.getCell((short)5).getCellStyle());

        rowTemp = sheet.getRow((short)11);
        row = sheet.createRow((short)++numlinea); 
        cell = row.createCell((short)1); 
        cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.preavisos.tabla.cif",idioma)
        		+":  "+preaviso.getCentroTrabajo().getCifnif());
        cell.setCellStyle(rowTemp.getCell((short)1).getCellStyle());
       
        row = sheet.createRow((short)numlinea); 
        cell = row.createCell((short)4); 
        cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.preavisos.tabla.num_centro",idioma)
        		+":  "+preaviso.getCentroTrabajo().getNumCentro());
        cell.setCellStyle(rowTemp.getCell((short)4).getCellStyle());
        cell = row.createCell((short)5); 
        cell.setCellStyle(rowTemp.getCell((short)5).getCellStyle());
        
        
        row = sheet.createRow((short)++numlinea); 
        sheet.addMergedRegion(new Region(numlinea,Short.parseShort("1"),numlinea,Short.parseShort("4")));
        cell = row.createCell((short)1); 
        valor = W83bUtilidadesExcel.mayusculasCampoExcel(preaviso.getCentroTrabajo().getRazonSocial());
        cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.preavisos.tabla.razon_social",idioma)
        		+":  "+valor);
        cell.setCellStyle(rowTemp.getCell((short)1).getCellStyle());
        cell = row.createCell((short)4); 
        cell.setCellStyle(rowTemp.getCell((short)4).getCellStyle());
     	tamanyoTexto = cell.getStringCellValue().length();
        if(93<tamanyoTexto){
        	row.setHeightInPoints((short)(22*(tamanyoTexto/93)+1));
        }
        cell = row.createCell((short)5); 
        cell.setCellStyle(rowTemp.getCell((short)5).getCellStyle());
        
        row = sheet.createRow((short)++numlinea); 
        sheet.addMergedRegion(new Region(numlinea,Short.parseShort("1"),numlinea,Short.parseShort("4")));
        cell = row.createCell((short)1); 
        valor = W83bUtilidadesExcel.mayusculasCampoExcel(preaviso.getCentroTrabajo().getDomicilio());
        cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.centroTrabajo.domicilioTrabajo",idioma)
        		+":  "+valor);
        cell.setCellStyle(rowTemp.getCell((short)1).getCellStyle());
        cell = row.createCell((short)4); 
        cell.setCellStyle(rowTemp.getCell((short)4).getCellStyle());
     	tamanyoTexto = cell.getStringCellValue().length();
        if(93<tamanyoTexto){
        	row.setHeightInPoints((short)(22*(tamanyoTexto/93)+1));
        }
        cell = row.createCell((short)5); 
        cell.setCellStyle(rowTemp.getCell((short)5).getCellStyle());
        
        row = sheet.createRow((short)++numlinea); 
        cell = row.createCell((short)1); 
        cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.centroTrabajo.codPostal",idioma)
        		+":  "+preaviso.getCentroTrabajo().getCodPostal());
        cell.setCellStyle(rowTemp.getCell((short)1).getCellStyle());
        
        row = sheet.createRow((short)numlinea); 
        cell = row.createCell((short)4); 
        valor = W83bUtilidadesExcel.mayusculasCampoExcel(preaviso.getCentroTrabajo().getLocalidad());
        if(StringUtils.isEmpty(valor)){
        	valor="";
        }
        cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.centroTrabajo.localidad",idioma)
        		+":  "+valor);
        cell.setCellStyle(rowTemp.getCell((short)4).getCellStyle());
        cell = row.createCell((short)5); 
        cell.setCellStyle(rowTemp.getCell((short)5).getCellStyle());
        
        rowTemp = sheet.getRow((short)18);
        row = sheet.createRow((short)++numlinea); 
        cell = row.createCell((short)1); 
        valor = W83bUtilidadesExcel.mayusculasCampoExcel(preaviso.getCentroTrabajo().getMunicipio());
       
        cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.centroTrabajo.municipio",idioma)
        		+":  ");
       
        cell.setCellStyle(rowTemp.getCell((short)1).getCellStyle());
        cell = row.createCell((short)2); 
        cell.setCellValue(valor);
        int tamanyo = cell.getStringCellValue().length();
        
        if(17<tamanyo){
        	row.setHeightInPoints((short)(25*(tamanyo/17)+1));
        }
        
        cell.setCellStyle(rowTemp.getCell((short)2).getCellStyle());
        HSSFCellStyle estilo =  rowTemp.getCell((short)2).getCellStyle();
        estilo.setAlignment(HSSFCellStyle.ALIGN_JUSTIFY);
        cell.setCellStyle(estilo);
       
        cell = row.createCell((short)3); 
        cell.setCellStyle(rowTemp.getCell((short)3).getCellStyle());
        
        row = sheet.getRow((short)numlinea); 
        cell = row.createCell((short)4); 
        valor = W83bUtilidadesExcel.mayusculasCampoExcel(preaviso.getCentroTrabajo().getTerritorio());
        cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.centroTrabajo.provincia",idioma)
        		+":  "+valor);
        cell.setCellStyle(rowTemp.getCell((short)4).getCellStyle());
        cell = row.createCell((short)5); 
        cell.setCellStyle(rowTemp.getCell((short)5).getCellStyle());
        
        ++numlinea;
        //Impugnaciones
        List datosImpugnaciones =preaviso.getListaImpugnaciones();
        if(null!=datosImpugnaciones
        		&&datosImpugnaciones.size()>0){
	        rowTemp = sheet.getRow((short)10);
	        row = sheet.createRow((short)++numlinea); 
	        cell = row.createCell((short)1);
	        cell.setCellStyle(rowTemp.getCell((short)1).getCellStyle());
	        cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.preavisos.labels.impugnaciones",idioma));
	        cell = row.createCell((short)2);
	        cell.setCellStyle(rowTemp.getCell((short)2).getCellStyle());
	        cell = row.createCell((short)3);
	        cell.setCellStyle(rowTemp.getCell((short)3).getCellStyle());
	        cell = row.createCell((short)4);
	        cell.setCellStyle(rowTemp.getCell((short)4).getCellStyle());
	        cell = row.createCell((short)5);
	        cell.setCellStyle(rowTemp.getCell((short)5).getCellStyle());
	
	//        String [] datosImpugnacion=null;
	        rowTemp = sheet.getRow((short)11);
	        for (int i=0;i<datosImpugnaciones.size();i++)
	        {
	//        	if (StringUtils.isNotEmpty(datosImpugnaciones[i])){	
	        	W83bImpugnacionesBean impugnacion = (W83bImpugnacionesBean)datosImpugnaciones.get(i);
	        		row = sheet.createRow((short)++numlinea); 
	                cell = row.createCell((short)1);
	//	           	datosImpugnacion=datosImpugnaciones[i].split("_");
		           	if (StringUtils.isNotEmpty(impugnacion.getNum_impugnacion()))
		           	{
		           		cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.impugnaciones.nImpugnacion",idioma)
		           				+":  "+impugnacion.getNum_impugnacion());
		           	}
		           	else
		           	{
		                   cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.impugnaciones.nImpugnacion",idioma)
		                   		+":  ");
		           	}
		           	cell.setCellStyle(rowTemp.getCell((short)1).getCellStyle());
	               row = sheet.createRow((short)numlinea); 
	               cell = row.createCell((short)4); 
	           	if (StringUtils.isNotEmpty(impugnacion.getFecha_impugnacion()))
		           	{
		           		cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.impugnaciones.fImpugnacion",idioma)
		           				+":  "+impugnacion.getFecha_impugnacion());
		           	}
		           	else
		           	{
		                   cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.impugnaciones.fImpugnacion",idioma)
		                   		+":  ");
		           	}
	               cell.setCellStyle(rowTemp.getCell((short)4).getCellStyle());
	               cell = row.createCell((short)5); 
	               cell.setCellStyle(rowTemp.getCell((short)5).getCellStyle());
	               row = sheet.createRow((short)++numlinea); 
	               cell = row.createCell((short)1); 
	               cell.setCellStyle(rowTemp.getCell((short)1).getCellStyle());
	           	if (StringUtils.isNotEmpty(impugnacion.getTipo()))
		           	{
	            	   valor = W83bUtilidadesExcel.mayusculasCampoExcel(impugnacion.getTipo());
		           		cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.preavisos.labels.tipo",idioma)
		           				+":  "+impugnacion.getTipo());
		           	}
		           	else
		           	{
		                   cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.preavisos.labels.tipo",idioma)
		                   		+":  ");
		           	}
	               row = sheet.createRow((short)numlinea); 
	               sheet.addMergedRegion(new Region(numlinea,Short.parseShort("1"),numlinea,Short.parseShort("3")));//NOPMD
	               cell = row.createCell((short)1); 
	               rowTemp = sheet.getRow((short)17);
	               cell.setCellStyle(rowTemp.getCell((short)1).getCellStyle());
	               rowTemp = sheet.getRow((short)11);
	           	if (StringUtils.isNotEmpty(impugnacion.getNombre_arbitro()))
		           	{
	            	   valor = W83bUtilidadesExcel.mayusculasCampoExcel(impugnacion.getNombre_arbitro());
		           		cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.arbitros.nombreArbitro",idioma)
		           				+":  "+valor);
		           	}
		           	else
		           	{
		                   cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.arbitros.nombreArbitro",idioma)
		                   		+":  ");
		           	}
	            	tamanyoTexto = cell.getStringCellValue().length();
	               if(93<tamanyoTexto){
	               	row.setHeightInPoints((short)(22*(tamanyoTexto/93)+1));
	               }
	               cell = row.createCell((short)4); 
	               cell.setCellStyle(rowTemp.getCell((short)4).getCellStyle());
	               cell = row.createCell((short)5); 
	               cell.setCellStyle(rowTemp.getCell((short)5).getCellStyle());
	               row = sheet.createRow((short)++numlinea); 
	               cell = row.createCell((short)1);
	               cell.setCellStyle(rowTemp.getCell((short)1).getCellStyle());
	           	if (StringUtils.isNotEmpty(impugnacion.getFech_laudo()))
		           	{
		           		cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.impugnaciones.fechaLaudo",idioma)
		           				+":  "+impugnacion.getFech_laudo());
		           	}
		           	else
		           	{
		                   cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.impugnaciones.fechaLaudo",idioma)
		                   		+":  ");
		           	}
	               row = sheet.createRow((short)numlinea); 
	               cell = row.createCell((short)4); 
	               cell.setCellStyle(rowTemp.getCell((short)4).getCellStyle());
	           	if (StringUtils.isNotEmpty(impugnacion.getResultado()))
		           	{valor = W83bUtilidadesExcel.mayusculasCampoExcel(impugnacion.getResultado());
		           		cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.impugnaciones.resultado",idioma)
		           				+":  "+impugnacion.getResultado());
		           	}
		           	else
		           	{
		                   cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.impugnaciones.resultado",idioma)
		                   		+":  ");
		           	}
	               cell = row.createCell((short)5); 
	               cell.setCellStyle(rowTemp.getCell((short)5).getCellStyle());
	//        	}
	        	
	        	
	        }
        row = sheet.createRow((short)++numlinea); 
        rowTemp = sheet.getRow((short)18);
        cell = row.createCell((short)1); 
        cell.setCellStyle(rowTemp.getCell((short)1).getCellStyle());
        cell = row.createCell((short)2); 
        cell.setCellStyle(rowTemp.getCell((short)2).getCellStyle());
        cell = row.createCell((short)3); 
        cell.setCellStyle(rowTemp.getCell((short)3).getCellStyle());  
        cell = row.createCell((short)4); 
        cell.setCellStyle(rowTemp.getCell((short)4).getCellStyle());  
        cell = row.createCell((short)5); 
        cell.setCellStyle(rowTemp.getCell((short)5).getCellStyle());  
        }
        
        
        byte[] bytesExcel = W83bUtilidadesExcel.fncExcelToBytes(wb);
        
        response.setContentType("application/vnd.ms-excel");
        response.setContentLength(bytesExcel.length);
        response.setHeader("Content-disposition","attachment;filename=fichaPreavisos.xls");
        response.getOutputStream().write(bytesExcel);
        response.getOutputStream().flush();

		
		return null;
	}

}

